'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the currency of the checkout, and automatically re-renders
 * your component if the currency changes.
 */
function useCurrency() {
  const {
    localization
  } = api.useApi();
  return subscription.useSubscription(localization.currency);
}

exports.useCurrency = useCurrency;
