'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the delivery group the extension is attached to. This hook can only be used by extensions in the following
 * extension targets:
 * - purchase.checkout.shipping-option-list.render-before
 * - purchase.checkout.shipping-option-list.render-after
 */
function useDeliveryGroupTarget() {
  const api$1 = api.useApi();
  return subscription.useSubscription(api$1.target);
}

exports.useDeliveryGroupTarget = useDeliveryGroupTarget;
