'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current delivery groups for the checkout, and automatically re-renders
 * your component when delivery address or delivery option selection changes.
 */
function useDeliveryGroups() {
  const api$1 = api.useApi();
  if (!('deliveryGroups' in api$1)) {
    throw new errors.ExtensionHasNoMethodError('deliveryGroups', api$1.extension.target);
  }
  return subscription.useSubscription(api$1.deliveryGroups);
}

exports.useDeliveryGroups = useDeliveryGroups;
