'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current discount codes applied to the cart, and automatically re-renders
 * your component if discount codes are added or removed.
 */
function useDiscountCodes() {
  const {
    discountCodes
  } = api.useApi();
  return subscription.useSubscription(discountCodes);
}

/**
 * Returns the current discount allocations applied to the cart, and automatically re-renders
 * your component if discount allocations changed.
 */
function useDiscountAllocations() {
  const {
    discountAllocations
  } = api.useApi();
  return subscription.useSubscription(discountAllocations);
}

/**
 * Returns a function to add or remove discount codes.
 *
 * > Caution:
 * > See [security considerations](https://shopify.dev/docs/api/checkout-ui-extensions/configuration#network-access) if your extension retrieves discount codes through a network call.
 */
function useApplyDiscountCodeChange() {
  const api$1 = api.useApi();
  if ('applyDiscountCodeChange' in api$1) {
    return api$1.applyDiscountCodeChange;
  }
  throw new errors.ExtensionHasNoMethodError('applyDiscountCodeChange', api$1.extension.target);
}

exports.useApplyDiscountCodeChange = useApplyDiscountCodeChange;
exports.useDiscountAllocations = useDiscountAllocations;
exports.useDiscountCodes = useDiscountCodes;
