'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current gift cards applied to the cart, and automatically re-renders
 * your component if gift cards are added or removed.
 */
function useAppliedGiftCards() {
  const {
    appliedGiftCards
  } = api.useApi();
  return subscription.useSubscription(appliedGiftCards);
}

/**
 * Returns a function to add or remove gift cards.
 *
 * > Caution:
 * > See [security considerations](https://shopify.dev/docs/api/checkout-ui-extensions/configuration#network-access) if your extension retrieves gift card codes through a network call.
 */
function useApplyGiftCardChange() {
  const api$1 = api.useApi();
  if ('applyGiftCardChange' in api$1) {
    return api$1.applyGiftCardChange;
  }
  throw new errors.ExtensionHasNoMethodError('applyGiftCardChange', api$1.extension.target);
}

exports.useAppliedGiftCards = useAppliedGiftCards;
exports.useApplyGiftCardChange = useApplyGiftCardChange;
