'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `note` applied to the checkout.
 */
function useNote() {
  return subscription.useSubscription(api.useApi().note);
}

/**
 * Returns a function to mutate the `note` property of the checkout.
 */
function useApplyNoteChange() {
  const api$1 = api.useApi();
  if ('applyNoteChange' in api$1) {
    return api$1.applyNoteChange;
  }
  throw new errors.ExtensionHasNoMethodError('applyNoteChange', api$1.extension.target);
}

exports.useApplyNoteChange = useApplyNoteChange;
exports.useNote = useNote;
