'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the order information that's available post-checkout.
 */
function useOrder() {
  const api$1 = api.useApi();
  if ('order' in api$1) {
    return subscription.useSubscription(api$1.order);
  }
  throw new errors.ExtensionHasNoMethodError('order', api$1.extension.target);
}

exports.useOrder = useOrder;
