'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns all available payment options.
 */
function useAvailablePaymentOptions() {
  const api$1 = api.useApi();
  if ('availablePaymentOptions' in api$1) {
    return subscription.useSubscription(api$1.availablePaymentOptions);
  }
  throw new errors.ExtensionHasNoMethodError('availablePaymentOptions', api$1.extension.target);
}

/**
 * Returns payment options selected by the buyer.
 */
function useSelectedPaymentOptions() {
  const api$1 = api.useApi();
  if (!('selectedPaymentOptions' in api$1) || !('availablePaymentOptions' in api$1)) {
    throw new errors.ExtensionHasNoMethodError('selectedPaymentOptions', api$1.extension.target);
  }
  const selectedPaymentOptions = subscription.useSubscription(api$1.selectedPaymentOptions);
  const availablePaymentOptions = subscription.useSubscription(api$1.availablePaymentOptions);
  return react.useMemo(() => {
    const availablePaymentOptionsMap = {};
    for (const option of availablePaymentOptions) {
      availablePaymentOptionsMap[option.handle] = option;
    }
    return selectedPaymentOptions.map(paymentOption => {
      var _availablePaymentOpti;
      return {
        handle: paymentOption.handle,
        type: (_availablePaymentOpti = availablePaymentOptionsMap[paymentOption.handle]) === null || _availablePaymentOpti === void 0 ? void 0 : _availablePaymentOpti.type
      };
    });
  }, [availablePaymentOptions, selectedPaymentOptions]);
}

exports.useAvailablePaymentOptions = useAvailablePaymentOptions;
exports.useSelectedPaymentOptions = useSelectedPaymentOptions;
