'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the pickup location option the extension is attached to. This hook can only be used by extensions in the following
 * extension target:
 * - `purchase.checkout.pickup-location-option-item.render-after`
 */
function usePickupLocationOptionTarget() {
  const api$1 = api.useApi();
  if (!api$1.target || api$1.isTargetSelected === undefined) {
    throw new errors.ExtensionHasNoTargetError('usePickupLocationOptionTarget', api$1.extension.target);
  }
  const pickupLocationOptionTarget = subscription.useSubscription(api$1.target);
  const isTargetSelected = subscription.useSubscription(api$1.isTargetSelected);
  const pickupLocationOption = react.useMemo(() => {
    return {
      pickupLocationOptionTarget,
      isTargetSelected
    };
  }, [pickupLocationOptionTarget, isTargetSelected]);
  return pickupLocationOption;
}

exports.usePickupLocationOptionTarget = usePickupLocationOptionTarget;
