'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');

/**
 * Returns a function to apply a change to add a redeemable.
 */
function useApplyRedeemableChange() {
  const api$1 = api.useApi();
  if (!api$1.applyRedeemableChange) {
    throw new errors.ExtensionHasNoMethodError('useApplyRedeemableChange', api$1.extension.target);
  }
  return api$1.applyRedeemableChange;
}

exports.useApplyRedeemableChange = useApplyRedeemableChange;
