'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `shippingAddress` applied to the checkout.
 */
function useShippingAddress() {
  const shippingAddress = api.useApi().shippingAddress;
  if (!shippingAddress) {
    throw new errors.ScopeNotGrantedError('Using shipping address requires having shipping address permissions granted to your app.');
  }
  return subscription.useSubscription(shippingAddress);
}

/**
 * Returns a function to mutate the `shippingAddress` property of checkout.
 */
function useApplyShippingAddressChange() {
  const api$1 = api.useApi();
  if ('applyShippingAddressChange' in api$1) {
    return api$1.applyShippingAddressChange;
  }
  throw new errors.ExtensionHasNoMethodError('applyCartLinesChange', api$1.extension.target);
}

exports.useApplyShippingAddressChange = useApplyShippingAddressChange;
exports.useShippingAddress = useShippingAddress;
