'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the shipping option the extension is attached to. This hook can only be used by extensions in the following
 * extension targets:
 * - `purchase.checkout.shipping-option-item.render-after`
 * - `purchase.checkout.shipping-option-item.details.render`
 */
function useShippingOptionTarget() {
  const api$1 = api.useApi();
  if (!api$1.target || api$1.isTargetSelected === undefined) {
    throw new errors.ExtensionHasNoTargetError('useShippingOptionTarget', api$1.extension.target);
  }
  const shippingOptionTarget = subscription.useSubscription(api$1.target);
  const isTargetSelected = subscription.useSubscription(api$1.isTargetSelected);
  const shippingOption = react.useMemo(() => {
    return {
      shippingOptionTarget,
      isTargetSelected
    };
  }, [shippingOptionTarget, isTargetSelected]);
  return shippingOption;
}

exports.useShippingOptionTarget = useShippingOptionTarget;
