'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the time zone of the checkout, and automatically re-renders
 * your component if the time zone changes.
 */
function useTimezone() {
  const {
    localization
  } = api.useApi();
  return subscription.useSubscription(localization.timezone);
}

exports.useTimezone = useTimezone;
