'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

class CustomerAccountUIExtensionError extends Error {
  constructor(...args) {
    super(...args);
    this.name = 'CustomerAccountUIExtensionError';
  }
}
class ScopeNotGrantedError extends Error {
  constructor(...args) {
    super(...args);
    this.name = 'ScopeNotGrantedError';
  }
}
class ExtensionHasNoMethodError extends Error {
  constructor(method, target) {
    super(`Cannot call '${method}()' on target '${target}'. The corresponding property was not found on the API.`);
    this.name = 'ExtensionHasNoMethodError';
  }
}

exports.CustomerAccountUIExtensionError = CustomerAccountUIExtensionError;
exports.ExtensionHasNoMethodError = ExtensionHasNoMethodError;
exports.ScopeNotGrantedError = ScopeNotGrantedError;
