'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var subscription = require('./subscription.js');
var api = require('./api.js');

/**
 * Returns a list of an extension's granted capabilities.
 */
function useExtensionCapabilities() {
  return subscription.useSubscription(api.useApi().extension.capabilities);
}

/**
 * Returns whether or not a given capability of an extension is granted.
 */
function useExtensionCapability(capability) {
  return useExtensionCapabilities().includes(capability);
}

exports.useExtensionCapabilities = useExtensionCapabilities;
exports.useExtensionCapability = useExtensionCapability;
