'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns a `Money` value representing the minimum a buyer can expect to pay at the current
 * step of checkout. This value excludes amounts yet to be negotiated. For example,
 * the information step might not have delivery costs calculated.
 */
function useTotalAmount() {
  return subscription.useSubscription(api.useApi().cost.totalAmount);
}

exports.useTotalAmount = useTotalAmount;
