'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the country of the checkout, and automatically re-renders
 * your component if the country changes.
 */
function useLocalizationCountry() {
  const {
    localization
  } = api.useApi();
  return subscription.useSubscription(localization.country);
}

exports.useLocalizationCountry = useLocalizationCountry;
