'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current discount codes applied to the cart, and automatically re-renders
 * your component if discount codes are added or removed.
 */
function useDiscountCodes() {
  const {
    discountCodes
  } = api.useApi();
  return subscription.useSubscription(discountCodes);
}

/**
 * Returns the current discount allocations applied to the cart, and automatically re-renders
 * your component if discount allocations changed.
 */
function useDiscountAllocations() {
  const {
    discountAllocations
  } = api.useApi();
  return subscription.useSubscription(discountAllocations);
}

exports.useDiscountAllocations = useDiscountAllocations;
exports.useDiscountCodes = useDiscountCodes;
