'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current gift cards applied to the cart, and automatically re-renders
 * your component if gift cards are added or removed.
 */
function useAppliedGiftCards() {
  const {
    appliedGiftCards
  } = api.useApi();
  return subscription.useSubscription(appliedGiftCards);
}

exports.useAppliedGiftCards = useAppliedGiftCards;
