'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current language of the checkout, and automatically re-renders
 * your component if the language changes.
 */
function useLanguage() {
  const {
    localization
  } = api.useApi();
  return subscription.useSubscription(localization.language);
}

exports.useLanguage = useLanguage;
