'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the market of the checkout, and automatically re-renders
 * your component if it changes.
 */
function useLocalizationMarket() {
  const {
    localization
  } = api.useApi();
  return subscription.useSubscription(localization.market);
}

exports.useLocalizationMarket = useLocalizationMarket;
