'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

class ExtensionHasNoTargetError extends Error {
  constructor(target) {
    super(`Cannot call 'useTarget()' on target '${target}'. Property 'target' is not found on api.`);
    this.name = 'ExtensionHasNoTargetError';
  }
}

/**
 * Returns the cart line the extension is attached to. This hook can only be used by extensions in the
 * `purchase.cart-line-item.line-components.render` and `customer-account.order-status.cart-line-item.render-after`
 * extension targets. Until version `2023-04`, this hook returned a `PresentmentCartLine` object.
 */
function useTarget() {
  const api$1 = api.useApi();
  if (!api$1.target) {
    throw new ExtensionHasNoTargetError(api$1.extension.target);
  }
  return subscription.useSubscription(api$1.target);
}

exports.useTarget = useTarget;
