import { useContext } from 'react';
import { ExtensionApiContext } from '../context.mjs';
import { AdminUIExtensionError } from '../errors.mjs';

/**
 * Returns the full API object that was passed in to your
 * extension when it was created.
 */
function useApi(_target) {
  const api = useContext(ExtensionApiContext);
  if (api == null) {
    throw new AdminUIExtensionError('No extension api found.');
  }
  return api;
}

/**
 * Returns the full API object that was passed in to your
 * extension when it was created.
 * @deprecated you shoud be importing useApi instead
 */
function useExtensionApi() {
  return useApi();
}

export { useApi, useExtensionApi };
