import { render } from '@remote-ui/react';
import { extension } from '@shopify/ui-extensions/admin';
import { ExtensionApiContext } from './context.mjs';
import { jsx } from 'react/jsx-runtime';

function reactExtension(target, render$1) {
  // TypeScript can’t infer the type of the callback because it’s a big union
  // type. To get around it, we’ll just fake like we are rendering the
  // Playground extension, since all render extensions have the same general
  // shape (`RenderExtension`).
  return extension(target, async (root, api) => {
    const element = await render$1(api);
    await new Promise((resolve, reject) => {
      try {
        render( /*#__PURE__*/jsx(ExtensionApiContext.Provider, {
          value: api,
          children: element
        }), root, () => {
          resolve();
        });
      } catch (error) {
        // Workaround for https://github.com/Shopify/ui-extensions/issues/325
        // eslint-disable-next-line no-console
        console.error(error);
        reject(error);
      }
    });
  });
}

export { reactExtension, reactExtension as render };
