import { ScopeNotGrantedError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the proposed `billingAddress` applied to the checkout.
 */
function useBillingAddress() {
  const billingAddress = useApi().billingAddress;
  if (!billingAddress) {
    throw new ScopeNotGrantedError('Using billing address requires having billing address permissions granted to your app.');
  }
  return useSubscription(billingAddress);
}

export { useBillingAddress };
