import { ExtensionHasNoTargetError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the cart line the extension is attached to. This hook can only be used by extensions in the following
 * extension targets:
 * - `purchase.cart-line-item.line-components.render`
 * - `purchase.checkout.cart-line-item.render-after`
 * - `purchase.thank-you.cart-line-item.render-after`
 * - 'customer-account.order-status.cart-line-item.render-after'
 */
function useCartLineTarget() {
  const api = useApi();
  if (!api.target) {
    throw new ExtensionHasNoTargetError('useCartLineTarget', api.extension.target);
  }
  return useSubscription(api.target);
}

export { useCartLineTarget };
