import { ExtensionHasNoMethodError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current line items for the checkout, and automatically re-renders
 * your component if line items are added, removed, or updated.
 */
function useCartLines() {
  const {
    lines
  } = useApi();
  return useSubscription(lines);
}

/**
 * Returns a function to mutate the `lines` property of checkout.
 */
function useApplyCartLinesChange() {
  const api = useApi();
  if ('applyCartLinesChange' in api) {
    return api.applyCartLinesChange;
  }
  throw new ExtensionHasNoMethodError('applyCartLinesChange', api.extension.target);
}

export { useApplyCartLinesChange, useCartLines };
