import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * A `Money` value representing the subtotal value of the items in the cart at the current
 * step of checkout.
 */
function useSubtotalAmount() {
  return useSubscription(useApi().cost.subtotalAmount);
}

/**
 * A `Money` value representing the total shipping a buyer can expect to pay at the current
 * step of checkout. This value includes shipping discounts. Returns undefined if shipping
 * has not been negotiated yet, such as on the information step.
 */
function useTotalShippingAmount() {
  return useSubscription(useApi().cost.totalShippingAmount);
}

/**
 * A `Money` value representing the total tax a buyer can expect to pay at the current
 * step of checkout or the total tax included in product and shipping prices. Returns
 * undefined if taxes are unavailable.
 */
function useTotalTaxAmount() {
  return useSubscription(useApi().cost.totalTaxAmount);
}

/**
 * Returns a `Money` value representing the minimum a buyer can expect to pay at the current
 * step of checkout. This value excludes amounts yet to be negotiated. For example,
 * the information step might not have delivery costs calculated.
 */
function useTotalAmount() {
  return useSubscription(useApi().cost.totalAmount);
}

export { useSubtotalAmount, useTotalAmount, useTotalShippingAmount, useTotalTaxAmount };
