import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the country of the checkout, and automatically re-renders
 * your component if the country changes.
 */
function useLocalizationCountry() {
  const {
    localization
  } = useApi();
  return useSubscription(localization.country);
}

export { useLocalizationCountry };
