import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the delivery group the extension is attached to. This hook can only be used by extensions in the following
 * extension targets:
 * - purchase.checkout.shipping-option-list.render-before
 * - purchase.checkout.shipping-option-list.render-after
 */
function useDeliveryGroupTarget() {
  const api = useApi();
  return useSubscription(api.target);
}

export { useDeliveryGroupTarget };
