import { ExtensionHasNoMethodError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current delivery groups for the checkout, and automatically re-renders
 * your component when delivery address or delivery option selection changes.
 */
function useDeliveryGroups() {
  const api = useApi();
  if (!('deliveryGroups' in api)) {
    throw new ExtensionHasNoMethodError('deliveryGroups', api.extension.target);
  }
  return useSubscription(api.deliveryGroups);
}

export { useDeliveryGroups };
