import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current language of the checkout, and automatically re-renders
 * your component if the language changes.
 */
function useLanguage() {
  const {
    localization
  } = useApi();
  return useSubscription(localization.language);
}

export { useLanguage };
