import { ExtensionHasNoMethodError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the proposed `note` applied to the checkout.
 */
function useNote() {
  return useSubscription(useApi().note);
}

/**
 * Returns a function to mutate the `note` property of the checkout.
 */
function useApplyNoteChange() {
  const api = useApi();
  if ('applyNoteChange' in api) {
    return api.applyNoteChange;
  }
  throw new ExtensionHasNoMethodError('applyNoteChange', api.extension.target);
}

export { useApplyNoteChange, useNote };
