import { ExtensionHasNoMethodError } from '../errors.mjs';
import { useApi } from './api.mjs';

/**
 * Returns a function to apply a change to add a redeemable.
 */
function useApplyRedeemableChange() {
  const api = useApi();
  if (!api.applyRedeemableChange) {
    throw new ExtensionHasNoMethodError('useApplyRedeemableChange', api.extension.target);
  }
  return api.applyRedeemableChange;
}

export { useApplyRedeemableChange };
