import { ScopeNotGrantedError, ExtensionHasNoMethodError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the proposed `shippingAddress` applied to the checkout.
 */
function useShippingAddress() {
  const shippingAddress = useApi().shippingAddress;
  if (!shippingAddress) {
    throw new ScopeNotGrantedError('Using shipping address requires having shipping address permissions granted to your app.');
  }
  return useSubscription(shippingAddress);
}

/**
 * Returns a function to mutate the `shippingAddress` property of checkout.
 */
function useApplyShippingAddressChange() {
  const api = useApi();
  if ('applyShippingAddressChange' in api) {
    return api.applyShippingAddressChange;
  }
  throw new ExtensionHasNoMethodError('applyCartLinesChange', api.extension.target);
}

export { useApplyShippingAddressChange, useShippingAddress };
