import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the time zone of the checkout, and automatically re-renders
 * your component if the time zone changes.
 */
function useTimezone() {
  const {
    localization
  } = useApi();
  return useSubscription(localization.timezone);
}

export { useTimezone };
