import { useSubscription } from './subscription.mjs';
import { useApi } from './api.mjs';

/**
 * Returns a list of an extension's granted capabilities.
 */
function useExtensionCapabilities() {
  return useSubscription(useApi().extension.capabilities);
}

/**
 * Returns whether or not a given capability of an extension is granted.
 */
function useExtensionCapability(capability) {
  return useExtensionCapabilities().includes(capability);
}

export { useExtensionCapabilities, useExtensionCapability };
