import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current line items for the checkout, and automatically re-renders
 * your component if line items are added, removed, or updated.
 */
function useCartLines() {
  const {
    lines
  } = useApi();
  return useSubscription(lines);
}

export { useCartLines };
