import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current discount codes applied to the cart, and automatically re-renders
 * your component if discount codes are added or removed.
 */
function useDiscountCodes() {
  const {
    discountCodes
  } = useApi();
  return useSubscription(discountCodes);
}

/**
 * Returns the current discount allocations applied to the cart, and automatically re-renders
 * your component if discount allocations changed.
 */
function useDiscountAllocations() {
  const {
    discountAllocations
  } = useApi();
  return useSubscription(discountAllocations);
}

export { useDiscountAllocations, useDiscountCodes };
