import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the current gift cards applied to the cart, and automatically re-renders
 * your component if gift cards are added or removed.
 */
function useAppliedGiftCards() {
  const {
    appliedGiftCards
  } = useApi();
  return useSubscription(appliedGiftCards);
}

export { useAppliedGiftCards };
