import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the market of the checkout, and automatically re-renders
 * your component if it changes.
 */
function useLocalizationMarket() {
  const {
    localization
  } = useApi();
  return useSubscription(localization.market);
}

export { useLocalizationMarket };
