import { ExtensionHasNoMethodError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the order information that's available post-checkout.
 */
function useOrder() {
  const api = useApi();
  if ('order' in api) {
    return useSubscription(api.order);
  }
  throw new ExtensionHasNoMethodError('order', api.extension.target);
}

export { useOrder };
