import { ScopeNotGrantedError } from '../errors.mjs';
import { useApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the proposed `shippingAddress` applied to the checkout.
 */
function useShippingAddress() {
  const shippingAddress = useApi().shippingAddress;
  if (!shippingAddress) {
    throw new ScopeNotGrantedError('Using shipping address requires having shipping address permissions granted to your app.');
  }
  return useSubscription(shippingAddress);
}

export { useShippingAddress };
