import { useCallback, isValidElement, cloneElement } from 'react';
import { useApi } from './api.mjs';

/**
 * Returns the `I18nTranslate` interface used to translate strings.
 */
function useTranslate() {
  const {
    i18n
  } = useApi();
  const translate = useCallback((...args) => {
    const translation = i18n.translate(...args);
    if (!Array.isArray(translation)) {
      return translation;
    }
    return translation.map((part, index) => {
      if ( /*#__PURE__*/isValidElement(part)) {
        // eslint-disable-next-line react/no-array-index-key
        return /*#__PURE__*/cloneElement(part, {
          key: index
        });
      }
      return part;
    });
  }, [i18n]);
  return translate;
}

export { useTranslate };
