'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@remote-ui/core');

/**
 * Disclosure is an optionally controlled component used to put long sections of information
 * under content blocks that users can expand or collapse by pressing an activator.
 * The activator can be specified as children using an action component (`Button`, `Link` or `Pressable`)
 * or `Checkbox` component.
 * The content blocks can be specified as children inside a structure component (`View`, `InlineLayout`,
 * `BlockStack`, `Grid`, etc.).
 *
 * The library automatically applies the [WAI-ARIA Accordion pattern](https://www.w3.org/WAI/ARIA/apg/patterns/accordion/) to both the activator and the toggled content.
 */
const Disclosure = core.createRemoteComponent('Disclosure');

exports.Disclosure = Disclosure;
