'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * A simple isEqual function that can be used to compare two style objects that's
 * good enough for our use case on the style builder.
 */
function isEqual(first, second) {
  if (Object.is(first, second)) {
    return true;
  }
  if (typeof first === 'object' && typeof second === 'object') {
    if (Array.isArray(first) && Array.isArray(second)) {
      if (first.length === second.length) {
        return first.every((value, index) => isEqual(value, second[index]));
      }
    } else {
      const firstEntries = Object.entries(first);
      const secondEntries = Object.entries(second);
      if (firstEntries.length === secondEntries.length) {
        return firstEntries.every(([key]) => isEqual(first[key], second[key]));
      }
    }
  }
  return false;
}

exports.isEqual = isEqual;
