import { createRemoteRoot } from '@remote-ui/core';

/**
 * This function takes an extension function that is expecting a `RemoteRoot` as its
 * first argument, and returns a new function that accepts a `RemoteChannel` instead.
 * This is a convenience that allows the raw UI extension API to only expose the simpler
 * `RemoteChannel` type, while allowing the extension to use the more powerful `RemoteRoot`,
 * provided by a version of `@remote-ui/core` that the extension controls.
 */
function createExtensionRegistrationFunction() {
  const extensionWrapper = (target, implementation) => {
    var _shopify;
    async function extension(...args) {
      // Rendering extensions have two arguments. Non-rendering extensions don’t have
      // a `RemoteChannel` that needs to be normalized, so we can just pass the arguments
      // through.
      if (args.length === 1) {
        return implementation(...args);
      }
      const [{
        channel,
        components
      }, api] = args;
      const root = createRemoteRoot(channel, {
        components,
        strict: true
      });
      let renderResult = implementation(root, api);
      if (typeof renderResult === 'object' && renderResult != null && 'then' in renderResult) {
        renderResult = await renderResult;
      }
      root.mount();
      return renderResult;
    }
    (_shopify = globalThis.shopify) === null || _shopify === void 0 ? void 0 : _shopify.extend(target, extension);
    return extension;
  };
  return extensionWrapper;
}

export { createExtensionRegistrationFunction };
