export type Size = 'small' | 'medium' | 'large';
export type ScaleType = 'fill' | 'fit' | 'crop';
export interface ThumbnailProps {
    size?: Size;
    scaleType?: ScaleType;
    /** URL for the thumbnail image. */
    source: string;
    /** Alt text for the thumbnail. */
    alt: string;
}
/**
 * Thumbnails are used as a visual anchor and identifier for an object. They should be used along with text to provide context.
 */
export declare const Thumbnail: "Thumbnail" & {
    readonly type?: "Thumbnail" | undefined;
    readonly props?: ThumbnailProps | undefined;
    readonly children?: true | undefined;
};
//# sourceMappingURL=Thumbnail.d.ts.map