export interface NavigationApiContent {
    /** Navigate to a route in current navigation tree.
     * Pushes the specified screen if it isn't present in the navigation tree, goes back to a created screen otherwise.
     * @param screenName the name of the screen you want to navigate to.
     * @param params the parameters you want to pass to that screen.
     */
    navigate(screenName: string, params?: any): void;
    /** Pops the currently shown screen */
    pop(): void;
    /** Dismisses the modal highest on the stack */
    dismiss(): void;
}
/**
 * Access the navigation API for navigation functionality from a full screen modal.
 */
export interface NavigationApi {
    navigation: NavigationApiContent;
}
//# sourceMappingURL=navigation-api.d.ts.map