import type { RenderExtension, RenderExtensionWithRemoteRoot } from '../extension';
export interface ExtensionRegistrationFunction<ExtensionTargets> {
    <Target extends keyof ExtensionTargets>(target: Target, implementation: ExtensionTargets[Target]): ExtensionTargets[Target];
}
export interface ExtensionRegistrationFunctionWithRoot<ExtensionTargets> {
    <Target extends keyof ExtensionTargets>(target: Target, implementation: ExtensionTargets[Target] extends RenderExtension<infer Api, infer Components> ? RenderExtensionWithRemoteRoot<Api, Components> : ExtensionTargets[Target]): ExtensionTargets[Target];
}
/**
 * This function takes an extension function that is expecting a `RemoteRoot` as its
 * first argument, and returns a new function that accepts a `RemoteChannel` instead.
 * This is a convenience that allows the raw UI extension API to only expose the simpler
 * `RemoteChannel` type, while allowing the extension to use the more powerful `RemoteRoot`,
 * provided by a version of `@remote-ui/core` that the extension controls.
 */
export declare function createExtensionRegistrationFunction<ExtensionTargets>(): ExtensionRegistrationFunctionWithRoot<ExtensionTargets>;
//# sourceMappingURL=registration.d.ts.map